#pragma once
#include <windows.h>

struct SH2PluginInfos
{
	// memory interface
	unsigned char   (_fastcall * pfReadByte)(unsigned long address);
	unsigned short  (_fastcall * pfReadWord)(unsigned long address);
	unsigned long   (_fastcall * pfReadLong)(unsigned long address);
	void   (_fastcall * pfWriteByte)(unsigned long address,unsigned char data);
	void   (_fastcall * pfWriteWord)(unsigned long address,unsigned short data);
	void   (_fastcall * pfWriteLong)(unsigned long address,unsigned long data);
	// zones were opcodes are fetched
	// byteswaped areas
	unsigned char *IplROM;
	unsigned char *WorkRAMLow;
	unsigned char *WorkRAMHigh;
	// function to write text in the emu's client area
	// color:0x00RRGGBB
	// please do not use "/n" character, use instead multiple calls to function to write multiple lines
	void   (__cdecl * pfWriteText)(char *text,unsigned long color);
	// handle to the application's handle
	HINSTANCE hInstance;
	// Plugin version
	// you must return the plugin interface version you implement
	// format: 0xnm for version n.m
	unsigned char version;
};

#if defined(__cplusplus)
extern "C" {
#endif

//////////////////////////////////////
// SH2 plugin interface version 1.0 //
//////////////////////////////////////

// called to init the plugin, return true if success
__declspec(dllexport) bool _cdecl InitSH2Plugin(SH2PluginInfos * infos);
// called to deinit the plugin
__declspec(dllexport) void _cdecl DeInitPlugin(void);
// for the about dialog box of the plugin
__declspec(dllexport) void _cdecl DisplayPluginInfo(void);
// must display a dialog box to configure the plugin
__declspec(dllexport) void _cdecl SetupPlugin(void);

// executes at least min_number of cycles and returns the effective number of cycles ran
// this function is responsible for runing the master SH2 and the slave SH2 if necessary
__declspec(dllexport) int _cdecl SH2RunCycles(int min_number);
// performs a reset of the two SH2
__declspec(dllexport) void _cdecl ResetMasterSH2(void);
__declspec(dllexport) void _cdecl ResetSlaveSH2(void);
// turns the slave SH2 on
__declspec(dllexport) void _cdecl SlaveSH2On(void);
// turns the slave SH2 off
__declspec(dllexport) void _cdecl SlaveSH2Off(void);
// master SH2 interrupt request
__declspec(dllexport) void _cdecl MasterSH2InterruptRequest(unsigned char vector,unsigned char level);
// slave SH2 interrupt request
__declspec(dllexport) void _cdecl SlaveSH2InterruptRequest(unsigned char vector,unsigned char level);
// master SH2 input capture signal
__declspec(dllexport) void _cdecl MasterSH2InputCaptureSignal(void);
// slave SH2 input capture signal
__declspec(dllexport) void _cdecl SlaveSH2InputCaptureSignal(void);

// called when master PC is modified when a binary is loaded
__declspec(dllexport) void _cdecl MasterSH2SetPC(unsigned long PC);

#if defined(__cplusplus)
}
#endif